/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.target;

import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.util.IRayTraceRotate;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class EntityAILook
extends EntityAIBase {
    private boolean forced = false;
    private Entity forcedEntity = null;
    private int idle = 0;
    private double lookX;
    private double lookY;
    private double lookZ;
    private final EntityNPCInterface npc;
    boolean rotateBody;
    public boolean fastRotation = false;

    public EntityAILook(EntityNPCInterface npcIn) {
        this.npc = npcIn;
        this.func_75248_a(AiMutex.LOOK);
    }

    public void func_75251_c() {
        this.rotateBody = false;
        this.forced = false;
        this.forcedEntity = null;
    }

    public void rotate(Entity entity) {
        this.forced = true;
        this.forcedEntity = entity;
    }

    public void rotate(int degrees) {
        this.forced = true;
        this.npc.field_70761_aq = degrees;
        this.npc.field_70177_z = degrees;
        this.npc.field_70759_as = degrees;
    }

    public boolean func_75250_a() {
        return !this.npc.isAttacking() && this.npc.func_70661_as().func_75500_f() && !this.npc.func_70608_bn() && this.npc.func_70089_S() && (!CustomNpcs.ShowCustomAnimation || !this.npc.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.INIT, AnimationKind.INTERACT, AnimationKind.DIES));
    }

    public void func_75249_e() {
        this.rotateBody = this.npc.ais.getStandingType() == 0 || this.npc.ais.getStandingType() == 3;
    }

    public void func_75246_d() {
        CustomNpcs.debugData.start((Object)this.npc);
        Entity lookat = null;
        if (this.forced && this.forcedEntity != null) {
            lookat = this.forcedEntity;
        } else if (this.npc.isInteracting()) {
            Iterator<EntityLivingBase> ita = this.npc.interactingEntities.iterator();
            double closestDistance = 12.0;
            while (ita.hasNext()) {
                EntityLivingBase entity = ita.next();
                double distance = entity.func_70032_d((Entity)this.npc);
                if (distance < closestDistance) {
                    closestDistance = entity.func_70032_d((Entity)this.npc);
                    lookat = entity;
                    continue;
                }
                if (distance <= 12.0) continue;
                ita.remove();
            }
        } else if (this.npc.ais.getStandingType() == 2 || this.npc.ais.getStandingType() == 4) {
            lookat = this.npc.field_70170_p.func_72890_a((Entity)this.npc, 16.0);
        }
        if (lookat != null) {
            this.npc.updateLook = this.npc.lookAt == null || !this.npc.lookAt.equals((Object)lookat);
            this.npc.lookAt = lookat;
            double posY = lookat instanceof EntityLivingBase ? lookat.field_70163_u + (double)lookat.func_70047_e() : (lookat.func_174813_aQ().field_72338_b + lookat.func_174813_aQ().field_72337_e) / 2.0;
            this.setLookPosition(lookat.field_70165_t, posY, lookat.field_70161_v, this.npc.func_70646_bf());
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        this.npc.updateLook = this.npc.lookAt != null;
        this.npc.lookAt = null;
        if (this.rotateBody) {
            if (this.idle == 0 && this.npc.func_70681_au().nextFloat() < 0.004f) {
                double d0 = Math.PI * this.npc.func_70681_au().nextDouble() * 2.0;
                if (this.npc.ais.getStandingType() == 3) {
                    d0 = Math.PI / 180 * (double)this.npc.ais.orientation + 0.6283185307179586 + 1.8849555921538759 * this.npc.func_70681_au().nextDouble();
                }
                this.lookX = Math.cos(d0);
                this.lookY = (this.npc.func_70681_au().nextFloat() - 0.5f) * 0.85f;
                this.lookZ = Math.sin(d0);
                IRayTraceRotate data = Util.instance.getAngles3D(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, this.lookX, this.lookY, this.lookZ);
                this.npc.lookPos[0] = (float)data.getYaw();
                this.npc.lookPos[1] = (float)data.getPitch();
                this.npc.updateClient();
                this.idle = 20 + this.npc.func_70681_au().nextInt(20);
            } else if ((this.npc.ais.getStandingType() == 3 || this.npc.ais.getStandingType() == 0) && this.lookX != 0.0 && this.lookY != 0.0 && this.lookZ != 0.0) {
                this.setLookPosition(this.npc.field_70165_t + this.lookX, this.npc.field_70163_u + (double)this.npc.func_70047_e() + this.lookY, this.npc.field_70161_v + this.lookZ, this.npc.func_70646_bf());
            }
            if (this.idle > 0) {
                --this.idle;
                this.setLookPosition(this.npc.field_70165_t + this.lookX, this.npc.field_70163_u + (double)this.npc.func_70047_e() + this.lookY, this.npc.field_70161_v + this.lookZ, this.npc.func_70646_bf());
            }
        }
        if (!(this.npc.ais.getStandingType() != 1 && this.npc.ais.getStandingType() != 4 || this.forced)) {
            this.npc.field_70761_aq = this.npc.ais.orientation;
            this.npc.field_70177_z = this.npc.ais.orientation;
            this.npc.field_70759_as = this.npc.ais.orientation;
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    private void setLookPosition(double x, double y, double z, int verticalFaceSpeed) {
        if (!CustomNpcs.ShowCustomAnimation || !this.npc.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.INIT, AnimationKind.INTERACT, AnimationKind.DIES)) {
            this.npc.func_70671_ap().func_75650_a(x, y, z, 10.0f, (float)verticalFaceSpeed);
        }
    }
}

